
#ifndef _1_CRYS_Ext_ATP_RSA_Acceptance_h_H
#define _1_CRYS_Ext_ATP_RSA_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_RSA_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:18:08 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RSA_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct SEP_RSA_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2]; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint8_t					TST_dP[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_dQ[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
    DxUint16_t					TST_KeySize;
    DxUint16_t					TST_DPSize;
    DxUint16_t					TST_PubExponentSize; 
	DxUint8_t 					TST_input_data[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	
	DxUint8_t 					TST_output_data[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	
	DxUint8_t 					TST_Expected_output_data[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	      
} SEP_RSA_TestDataStruct;

typedef struct SEP_RSA_TestSignVerifyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2]; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint8_t					TST_dP[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_dQ[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
    DxUint16_t					TST_KeySize;
    DxUint16_t					TST_DPSize; 
    DxUint16_t					TST_PubExponentSize; 
    DxUint16_t					TST_SaltLength;
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t 					TST_input_dataSize;
	DxUint8_t 					TST_output_signiture[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	      
} SEP_RSA_TestSignVerifyDataStruct;

typedef struct SEP_RSA_TestExtHashSignVerifyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2]; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint8_t					TST_dP[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_dQ[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
    DxUint16_t					TST_KeySize;
    DxUint16_t					TST_DPSize; 
    DxUint16_t					TST_PubExponentSize; 
    DxUint16_t					TST_SaltLength;   
	DxUint8_t 					TST_input_hash_SHA1[CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES];
	DxUint8_t 					TST_input_hash_MD5[CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES];	
    DxUint8_t 					TST_input_hash_SHA224[CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES];
    DxUint8_t 					TST_input_hash_SHA256[CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES];	
    DxUint8_t 					TST_input_hash_SHA384[CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES];
    DxUint8_t 					TST_input_hash_SHA512[CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES];	
	DxUint8_t 					TST_output_signiture[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	      
} SEP_RSA_TestExtHashSignVerifyDataStruct;


typedef struct SEP_RSA_TestGetKeyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
	DxUint16_t					TST_PrivExponentSize; 
	DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint16_t					TST_PubExponentSize; 
	DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint16_t					TST_ModulusSize;
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_pSize; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint16_t					TST_qSize; 
	DxUint8_t					TST_Dp[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_DpSize; 
	DxUint8_t					TST_Dq[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_DqSize; 
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
	DxUint16_t					TST_QinvSize; 
} SEP_RSA_TestGetKeyDataStruct;



/******** Public Variables ********/
/******** Public Functions ********/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_Ext_ATP_RSA_Acceptance_PRIME_EncDec      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RSA primitive encrypt and decrypt function,
*  implemented as external SEP application  
*  This also outputs the results to an output buffer or the same input buffer.
*  Keys size used (in bits) - 2048                                                        
* Algorithm:       
* 1. Call the SEPQA_RSA_PRIME_EncDec function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PRIME_EncDec ( void );

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_EncDec         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 encrypt and decrypt 
 *  according to PKCS#1 Ver1.5 implemented as external SEP application  
 *  This also outputs the results to an output buffer or the same input buffer.
 *  Keys size used (in bits) - 2048                                                        
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PKCS1v15_EncDec function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_EncDec (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify        
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify 
 *  implemented as external SEP application  
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/
CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify      
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify
 *  implemented as external SEP application  
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PKCS1v15_Integrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/
CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_OAEP_EncDec         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA OAEP encrypt and decrypt
 *  according to PKCS#1 Ver2.1 implemented as external SEP application  
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_OAEP_EncDec function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_OAEP_EncDec (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PSS_NonIntegrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify       
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PSS_Integrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify (int TST_KeyGeneration_TestStatus);


/*****************************************************************************
* Function Name:                                                           
*  CRYS_Ext_ATP_RSA_Acceptance_PRIME_SignVerify      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  Description:                                                                 
*  This function Is a Acceptance test for RSA primitive Sign & Verify                  
*  This function signs and verifies known vectors using RSA primitives                                  ,
*  implemented as external SEP application  
*  This also outputs the results to an output buffer or the same input buffer.
*  Keys size used (in bits) - 2048                                                        
* Algorithm:       
* 1. Call the SEPQA_RSA_PRIME_SignVerify function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PRIME_SignVerify ( void );

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify        
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify
 *  When the Hash for the Sign is preformed externally                   
 *  This function Signs & Verifies hash vectors using RSA PKCS1v15
 *  Vectors sizes used (in byte) - SHA1 - 20, MD5 - 16                                                      
 *  Key sizes used     (in bits) - 2048
 * Algorithm:                       
 * 1. Call the SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code               
 *
 **************************/

CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v2.1 PSS Sign & Verify
 *  When the Hash for the Sign is preformed externally                   
 *  This function Signs & Verifies hash vectors using RSA PKCS1v2.1 PSS                                                   
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 *   Algorithm:                       
 * 1. Call the SEPQA_RSA_PSS_ExternalHash_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code            
 *
 **************************/


CRYSError_t CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_Get_PrivAndPubKey         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v2.1 PSS Sign & Verify
 *  When the Hash for the Sign is preformed externally                   
 *  This function Signs & Verifies hash vectors using RSA PKCS1v2.1 PSS                                                   
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 *   Algorithm:                       
 * 1. Call the SEPQA_RSA_PSS_ExternalHash_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code            
 *
 **************************/
 
 CRYSError_t CRYS_Ext_ATP_RSA_Get_PrivAndPubKey(int TST_KeyGeneration_TestStatus);

#ifdef __cplusplus
}
#endif

#endif


#endif

